model Ex12_5
//Parameter Section
parameter Real T1(unit = "C") = 300 "Temperature of plate 1";
parameter Real T3(unit = "C") = 25 "Temperature of the atmosphere";
parameter Real epsilon(unit = "nil") = 0.56 "Emissivity of steel plates"; // epsilon 1 = epsilon 3
parameter Real epsilon2(unit = "nil") = 1 "Emissivity of lacquered sheet";
parameter Real sigma(unit = "W/m^2.K^4") = 5.67*10^(-8) "Stefan-Boltzmann constant";
//=============================================================================
//Variable Section
Real T2(unit = "C") "Temperature of the lacquered sheet at equilibrium";
Real q(unit = "W/m^2") "Heat flux";
//=============================================================================
//Equation Section
equation 
// At equilibrium, Q12 = Q23 and A1 = A2
// q12 = q23 = q
(((T1+273)^4-(T2+273)^4)/((1/epsilon)+(1/epsilon2)-1)) = (((T2+273)^4-(T3+273)^4)/((1/epsilon2)+(1/epsilon)-1));
q = (sigma*((T1+273)^4-(T2+273)^4))/((1/epsilon)+(1/epsilon2)-1);
end Ex12_5;
