model Ex13_1
//Parameter Section
parameter Real MA(unit = "g/gmole") = 39.944 "Molecular weight of Argon";
parameter Real MB(unit = "g/gmole") = 32 "Molecular weight of Oxygen";
parameter Real sigma_A(unit = "Angstrom") = 3.418 "Characteristic length parameter of species A";
parameter Real sigma_B(unit = "Angstrom") = 3.433 "Characteristic length parameter of species B";
parameter Real P(unit = "atm") = 1 "Total pressure";
parameter Real T(unit = "K") = 293.2 "Temperature";
parameter Real omegaD_AB(unit = "nil") = 1.003 "Collision Integral";
//========================================================================
//Variable Section 
Real sigma_AB(unit = "Angstrom") "Characteristic length parameter of binary mixture";
Real D_AB(unit = "cm^2/s") "Diffusivity";
//========================================================================
//EquationSection
equation 
sigma_AB = (sigma_A+sigma_B)/2;
D_AB = (0.0018583*sqrt(T^3*((1/MA)+(1/MB))))/(P*sigma_AB^2*omegaD_AB); //Chapman-Enskog equation
end Ex13_1;
