package Ex13_3
model Ex13_3_A
//=================================================================================
//Parameter Section
parameter Real Pc_A(unit = "atm") = 45.8 "Critical pressure of A(Methane)";
parameter Real Pc_B(unit = "atm") = 50.0 "Critical pressure of B(Ethane)";
parameter Real Tc_A(unit = "F") = 190.7 "Critical Temperature of methane";
parameter Real Tc_B(unit = "F") = 282.4 "Critical Temperature of ethane";
parameter Real M_A(unit = "kg/kmole") = 16.04 "Molecular weight of methane";
parameter Real M_B(unit = "kg/kmole") = 30.07 "Molecular weight of ethane";
parameter Real P(unit = "atm") = 1 "Total Pressure of the system";
parameter Real T_F(unit = "F") = 104 "Temperature of the system";
parameter Real a(unit = "nil") = 2.745*10^(-4) "constant";
parameter Real b(unit = "nil") = 1.823 "constant";
//=================================================================================
//Variable Section
Real T(unit = "K") "Temperature in K";
Real D_AB(unit = "cm^2/s") "Diffusivity for the methane-ethane system";
//=================================================================================
//Equation Section
equation
T = ((T_F-32)/1.8)+273.15;
D_AB =  ((a*(T/(sqrt(Tc_A*Tc_B)))^b)*(Pc_A*Pc_B)^(1/3)*(Tc_A*Tc_B)^(5/12)*((1/M_A)+(1/M_B))^(1/2))/P;
//Slattery - Bird Equation
end Ex13_3_A;
//The answer may slightly vary due to rounding off values




//=================================================================================

//=================================================================================
model Ex13_3_B
//=================================================================================
//Parameter Section
parameter Real Pc_A(unit = "atm") = 45.8 "Critical pressure of A(Methane)";
parameter Real Pc_B(unit = "atm") = 50.0 "Critical pressure of B(Ethane)";
parameter Real Tc_A(unit = "F") = 190.7 "Critical Temperature of methane";
parameter Real Tc_B(unit = "F") = 282.4 "Critical Temperature of ethane";
parameter Real T_F(unit = "F") = 104 "Temperature of the system";
parameter Real M_A(unit = "kg/kmole") = 16.04 "Molecular weight of methane";
parameter Real M_B(unit = "kg/kmole") = 30.07 "Molecular weight of ethane";
parameter Real P(unit = "atm") = 1 "Total Pressure of the system";
parameter Real Omega_D_AB(unit = "nil") = 1.145 "Collision Integral";
//=================================================================================
//Variable Section
Real T(unit = "K") "Temperature in K";
Real sigma_A(unit = "Angstrom") "Characteristic length parameter of A"; 
Real sigma_B(unit = "Angstrom") "Characteristic length parameter of B";
Real sigma_AB(unit = "Angstrom") "Characteristic length parameter of binary mixture AB";
Real epsilon_A_by_K(unit = "F");//epsilon-energy of molcular attraction; K-Boltzmann's constant
Real epsilon_B_by_K(unit = "F");//epsilon-energy of molcular attraction; K-Boltzmann's constant
Real epsilon_AB_by_K(unit = "F");//epsilon-energy of molcular attraction; K-Boltzmann's constant
Real KT_by_epsilon_AB(unit = "nil") "Collision function";
Real D_AB(unit = "m^2/s") "Diffusivity for the methane-ethane system";
//=================================================================================
//Equation Section
equation
T = ((T_F-32)/1.8)+273.15; //Conversion factor C = (1/1.8)(F-32); K = C+273.15
sigma_A = 2.44*(Tc_A/Pc_A)^(1/3);
sigma_B = 2.44*(Tc_B/Pc_B)^(1/3);
sigma_AB = (sigma_A+sigma_B)/2;
epsilon_A_by_K = 0.77*Tc_A;
epsilon_B_by_K = 0.77*Tc_B;
epsilon_AB_by_K = sqrt(epsilon_A_by_K*epsilon_B_by_K);
KT_by_epsilon_AB = T/epsilon_AB_by_K;
D_AB = (0.0018583*sqrt(T^3*((1/M_A)+(1/M_B))))/(P*sigma_AB^2*Omega_D_AB); //Chapman Enskog Equation
end Ex13_3_B;
end Ex13_3;
