model Ex13_7
//Parameter Section
parameter Real D_AB_1(unit = "cm^2/s") = 0.151 "Diffusivity of the mixture at 293 K";
parameter Real T1(unit = "K") = 293 "Temperature of the mixture";
parameter Real T2(unit = "K") = 1500 "Temperature of the mixture";
parameter Real omega_AB_1(unit = "nil") = 1.047 "Collision Integral";
parameter Real omega_AB_2(unit = "nil") = 0.734 "Collision Integral";
parameter Real b(unit = "nil") = 1.823; //For non-polar gas pairs
//======================================================================================
//Variable Section
Real D_AB2(unit = "cm^2/s") "Diffusivity by Slattery Bird equation method";
Real D_AB_2(unit = "cm^2/s") "Diffusivity by Chapman-Enskog theoretical equation";
//======================================================================================
//EquationSection
equation
D_AB2/D_AB_1 = (T2/T1)^b;
D_AB_2/D_AB_1 = (T2/T1)^(3/2)*(omega_AB_1/omega_AB_2);
end Ex13_7;
