model Ex13_8
//Parameter Section
parameter Real psi_B(unit = "nil") = 1 "Association parameter";
parameter Real MW_A(unit = "g/gmole") = 60 "Molecular weight of the solute i.e. acidic acid";
parameter Real MW_B(unit = "g/gmole") = 18 "Molecular weight of the solvent i.e. water";
parameter Real mu(unit = "cP") = 1.496 "Viscosity of the water";
parameter Real rho_A(unit = "g/cm^3") = 0.937 "Density of the acetic acid";
parameter Real T(unit = "deg C") = 12.5 "Temperature of the dilute aqueous solution";
//============================================================================================
//Variable Section
Real V_A(unit = "cm^3/gmole") "Molar Volume of the solute";
Real D_AB(unit = "cm^2/s") "Diffusivity for acetic acid in dilute aqueous solution";
//============================================================================================
//Equation Section
equation
V_A = (1/rho_A)*MW_A; 
D_AB = (7.4*10^(-8)*sqrt(psi_B*MW_B)*(T+273))/(mu*V_A^0.6); //Wilke - Chang correlation
end Ex13_8;
