model Ex14_12
//Parameter Section
//A = NH3 B = N2
parameter Real T(unit = "deg C") = 298 "Temperature of the system";
parameter Real P_A1(unit = "Pa") = 1.013*10^4 "Pressure at point 1";
parameter Real P_A2(unit = "Pa") = 0.507*10^4 "Pressure at point 2";
parameter Real D_AB(unit = "m^2/s") = 0.23*10^(-4) "Diffusivity of NH3 into N2";
parameter Real R(unit = "J/kmole.K") = 8314 "Universal gas constant";
parameter Real delZ(unit = "m") = 10*10^(-2) "Length of the tube";
//=================================================================================
//Variable Section
Real N_A(unit = "kmole/m^2.s") "Flux";
//=================================================================================
//Equation Section
equation 
N_A = (D_AB*(P_A1-P_A2))/(R*T*delZ);
end Ex14_12;
