model Ex14_13
//Parameter Section
//A = Chloropicrin B = Air 
parameter Real D_AB(unit = "m^2/s") = 0.088*10^(-4) "Diffusivity of chloropicrin in air";
parameter Real p_A1(unit = "mmHg") = 23.81 "Vapour Pressure of chloropicrin at point 1";
parameter Real p_A2(unit = "mmHg") = 0 "Vapour pressure of chloropicrin at point 2"; //since it is pure air
parameter Real P_T(unit = "mmHg") = 770 "Total Pressure of the system";
parameter Real P_atm(unit = "mmHg") = 760 "Atmospheric pressure";
parameter Real T(unit = "K") = 298 "Temperature of the system";
parameter Real delz(unit = "m") = 11.14*10^(-2) "Distance from liquid level to top of the tube";
parameter Real A(unit = "m^2") = 2.29*10^(-4) "Surface area of liquid exposed for evaporation";
parameter Real R(unit = "J/kmole.K") = 8314 "Universal gas constant";
parameter Real MW(unit = "kg/kmole") = 164.5 "Molecular weight of chloropicrin";
//===========================================================================================================
//Variable Section
Real p_B1(unit = "mmHg") "Partial pressure of air at point 1";
Real p_B2(unit = "mmHg") "Partial pressure of air at point 2";
Real p_B_lm(unit = "N/m^2") "Logarithmic mean partial presssure";
Real NA(unit = "kmoles/s.m^2") "Flux of diffusion of chloropicrin into stagnant air";
Real Rate(unit = "kmole/sec") "Rate of evaporation of chloropicrin in kmole/s";
Real Rate_g_per_hr(unit = "g/hr") "Rate of evaporation of chloropicrin in kg/hr";
//===========================================================================================================
//Equation Section
equation
p_B1 = P_atm-p_A1;
p_B2 = P_atm-p_A2;
p_B_lm = (((p_B1-p_B2)*1.013*10^5)/log(p_B1/p_B2))/P_atm;
NA = (D_AB*(P_T*1.013*10^5)*((p_A1-p_A2)*1.013*10^5))/(R*T*delz*p_B_lm*P_atm*P_atm);
//1 atm = 1.013*10^5 N/m^2; 1 atm = 760 mmHg
Rate = NA*A;
Rate_g_per_hr = Rate*MW*3600*1000;
//1 hr = 3600 s; 1 kg = 1000g
end Ex14_13;
//The value for delz has been substituted wrongly as 10 cm in the textbook; So the answer provided in the textbook is wrong 
//The final answer provided in the textbook for rate of evaporation is also wrong
