model Ex14_4
//Parameter Section
//A - Methan B - Air
parameter Real T(unit = "C") = 273 "Temperature of the system";
parameter Real D_AB(unit = "m^2/s") = 1.57*10^(-5) "Diffusivity of CH4-air mixture";
parameter Real R(unit = "J/kmole.K") = 8314 "Universal gas constant";
parameter Real delZ(unit = "m") = 0.15 "Length of the tube";
parameter Real P_T(unit = "N/m^2") = 100*10^3 "Total Pressure of the system";
parameter Real d(unit = "m") = 2*10^(-3) "Diameter of the tube";
//=================================================================================
//Variable Section
Real p_A1(unit = "N/m^2") "Partial pressure of methane at point 1";
Real p_A2(unit = "N/m^2") "Partial pressure of methane at point 2";
Real N_A(unit = "kmole/m^2.s") "Flux";
Real A(unit = "m^2") "Area of cross-section of the tube";
Real Rate(unit = "kmole/s") "Rate of transport of CH4";
//=================================================================================
//Equation Section
equation 
//To calculate rate of transport when concentration of methane is 90 mol% in one tank and 5 mol% in the other
p_A1 = 0.9*P_T;
p_A2 = 0.05*P_T;
N_A = (D_AB*(p_A1-p_A2))/(R*T*delZ);
A = (3.14*d^2)/4;
Rate = N_A*A;
end Ex14_4;
//The final answer provided in the book is wrong
