model Ex14_5
//Parameter Section 
//A - HCl  B - Water
parameter Real MA(unit = "kg/kmole") = 36.5 "Molecular weight of HCl";
parameter Real MB(unit = "kg/kmole") = 18.02 "Molecular weight of water";
parameter Real conc_A_1(unit = "%") = 0.12 "Concentration of HCl in weight percent at point 1";
parameter Real conc_A_2(unit = "%") = 0.06 "Concentration of HCl in weight percent at point 2";
parameter Real rho_1(unit = "kg/m^3") = 1061 "Density of the solution at point 1";
parameter Real rho_2(unit = "kg/m^3") = 1030 "Density of the solution at point 2";
parameter Real D_AB(unit = "m^2/s") = 2.5*10^(-9) "Diffusivity of HCl-water system";
parameter Real delz(unit = "m") = 2*10^(-3) "Distance between two points";
//================================================================================================
//Variable Section
Real x_A1(unit = "nil") "Mole fraction of HCl at point 1";
Real x_A2(unit = "nil") "Mole fraction of HCl at point 2";
Real x_B1(unit = "nil") "Mole fraction of water at point 1";
Real x_B2(unit = "nil") "Mole fraction of water at point 1";
Real M1(unit = "kg/kmole") "Average Molecular weight at point 1"; 
Real M2(unit = "kg/kmole") "Average molecular weight at point 2";
Real x_B_lm(unit = "nil") "Logarithmic mean mole fraction";
Real rho_by_M_avg(unit = "kmole/m^3") "Average molar concentration";
Real NA(unit = "kmole/m^2.s") "Flux of diffusion of ethanol into water";
//================================================================================================
//Equation Section
equation
x_A1 = (conc_A_1/MA)/((conc_A_1/MA)+((1-conc_A_1)/MB));
x_A2 = (conc_A_2/MA)/((conc_A_2/MA)+((1-conc_A_2)/MB));
x_B1 = 1-x_A1;
x_B2 = 1-x_A2;
M1 = (MA*x_A1)+(MB*x_B1);
M2 = (MA*x_A2)+(MB*x_B2);
rho_by_M_avg = ((rho_1/M1)+(rho_2/M2))/2;
x_B_lm = (x_B1-x_B2)/log(x_B1/x_B2);
NA = (D_AB*rho_by_M_avg*(x_A1-x_A2))/(delz*x_B_lm);
end Ex14_5;
//The answer provided for (rho/M)avg in the textbook is wrong
