model Ex14_6
//Parameter Section
//A = Oxygen B = CO
parameter Real D_AB(unit = "m^2/s") = 1.87*10^(-5) "Diffusivity of oxygen in CO";
parameter Real P_T(unit = "N/m^2") = 1*10^5 "Total Pressure";
parameter Real P_A1(unit = "N/m^2") = 13000 "Partial pressure of oxygen at plane 1";
parameter Real P_A2(unit = "N/m^2") = 6500 "Partial pressure of oxygen at plane 2";
parameter Real delZ(unit = "m") = 2*10^(-3) "Distance between two planes";
parameter Real T(unit = "K") = 273 "Temperature of the system";
parameter Real R(unit = "J/kmole.K") = 8314 "Universal gas constant";
//=========================================================================================
//Variable Section
Real P_B1(unit = "N/m^2") "Partial pressure of CO at plane 1";
Real P_B2(unit = "N/m^2") "Partial pressure of CO at plane 2";
Real N_A(unit = "kmole/m^2.s") "Flux of diffusion of oxygen through a non-diffusing CO";
//=========================================================================================
//Equation Section
equation
P_B1 = P_T - P_A1;
P_B2 = P_T - P_A2;
N_A = (D_AB*P_T*(log(P_B2/P_B1)))/(R*T*delZ);
end Ex14_6;
