model Ex14_7
//Parameter Section
//A = Benzene B = Air
parameter Real D_AB(unit = "m^2/s") = 4.4*10^(-6) "Mass Diffusivity of benzene in air";
parameter Real P_T(unit = "N/m^2") = 200*10^3 "Total Pressure";
parameter Real P_A1(unit = "N/m^2") = 6*10^3 "Partial pressure of benzene at the left side of the layer";
parameter Real P_A2(unit = "N/m^2") = 1*10^3 "Partial pressure of benzene at right side of the layer";
parameter Real delZ(unit = "m") = 10*10^(-3) "Distance between two planes";
parameter Real T(unit = "K") = 298 "Temperature of the system";
parameter Real R(unit = "J/kmole.K") = 8314 "Universal gas constant";
parameter Real M(unit = "kg/kmole") = 78 "Molecular weight of benzene";
//==========================================================================================================
//Variable Section
Real P_B1(unit = "N/m^2") "Partial pressure of air at left side of the layer";
Real P_B2(unit = "N/m^2") "Partial pressure of air at right side of the layer";
Real P_Blm(unit = "N/m^2") "Logarithmic mean partial pressure";
Real N_A(unit = "kmole/m^2.s") "Molar Flux of diffusion of benzene through non-diffusing air 
in kmole/m^2.s";
Real NA(unit = "kg/m^2.s") "Mass Flux of diffusion of benzene through non-diffusing air in kg/m^2.s";
//==========================================================================================================
//Equation Section
equation
P_B1 = P_T - P_A1;
P_B2 = P_T - P_A2;
P_Blm = (P_B2-P_B1)/log(P_B2/P_B1);
N_A = (D_AB*P_T*(P_A1-P_A2))/(R*T*delZ*P_Blm);
NA = N_A*M;
end Ex14_7;
//The answer provided in the textbook is wrong
