model Ex3_10
//Parameter Section
parameter Real Vt_ftpersec(unit = "ft/s") = 1 "Velocity of the gas in ft/s";
parameter Real mu_cP(unit = "cP") = 0.026 "Viscosity of the gas in cP";
parameter Real Rhof(unit = "lb/ft^3") = 0.045 "Density of the gas in lb/ft^3";
parameter Real Rhos(unit = "g/cm^3") = 1.2 "Density of the single catalyst particle in g/cm^3";
parameter Real g(unit = "m/s^2") = 9.8 "Acceleration due to gravity";
//==================================================================================
//Variable Section
Real Vt(unit = "m/s") "Velocity of the gas in m/s";
Real mu(unit = "kg/m.s") "Viscosity of the gas in kg/m.s";
Real rhof(unit = "kg/m^3") "Density of the gas in kg/m^3";
Real rhos(unit = "kg/m^3") "Density of the single catalyst particle in kg/m^3";
Real D(unit = "m") "Diameter of the microspherical catalyst in m";
Real D_micron(unit = "micron") "Diameter of the microspherical catalyst in micron";
Real Re(unit = "nil") "Reynolds number";
//==================================================================================
//Equation Section
equation 
Vt = (Vt_ftpersec*12*2.54*10^(-2)); // 1 ft = 2.54*10^(-2) m
mu = mu_cP*10^(-3);
rhof = (Rhof*0.4536)/(0.3048^3);// 1 lb = 0.4536 kg
rhos = (Rhos*10^(-3))/(100^(-3));
D = ((Vt*18*mu)/(g*(rhos-rhof)))^(1/2);
D_micron = D*10^6;
Re = (D*Vt*rhof)/mu; //If Re<1, stoke's law is applicable
//Here, Re is less than 1 and therefore Stoke's law can be applied
end Ex3_10;
