model Ex3_7
//Parameter Section
parameter Real delta(unit = "m") = 0.0017 "Film thickness";
parameter Real mu(unit = "Pa.s") = 0.2 "Viscosity of the oil";
parameter Real rho(unit = "kg/m^3") = 820 "Density of the oil";
parameter Real g(unit = "m/s^2") = 9.8 "acceleration due to gravity";
//=====================================================================
//Variable Section
Real T(unit = "kg/m.s") "Liquid loading";
Real Re(unit = "nil") "Reynolds number";
Real V_z(unit = "m/s") "Velocity of the oil";
//=====================================================================
//Equation Section
equation
T = (rho^2*delta^3*g)/(3*mu);
Re = (4*T)/mu; // for Re < 1000 to 2000, the flow is laminar
V_z = (rho*g*delta^2)/(3*mu);
end Ex3_7;
