model Ex3_8
//Parameter section
parameter Real L(unit = "m") = 1 "Length of the tube";
parameter Real D(unit = "m") = 0.2*10^(-2) "Diameter of the tube";
parameter Real P0(unit = "N/m^2") = 1*10^6 "Pressure in fluid reservoir";
parameter Real P1(unit = "N/m^2") = 0 "Pressure reading";
parameter Real Q(unit = "m^3/s") = 10^(-7) "Volumetric flow rate";
parameter Real rho(unit = "kg/m^3") = 1100 "Density of the liquid"; //Specific gravity of the liquid is 1.1
//==========================================================================
//Variable section
Real R(unit = "m") "Radius of the tube";
Real delP(unit = "N/m^2") "Pressure drop";
Real mu(unit = "kg/m.s") "Viscosity of the fluid";
//==========================================================================
//Equation section
equation
R = D/2;
delP = P0-P1;
mu = (3.14*delP*R^4)/(8*Q*L); //Modification of Hagen-Poiseuille equation for laminar flow
end Ex3_8;
