model Ex6_9
//Parameter Section
parameter Real D(unit = "m") = 0.25 "Diameter of the tube";
parameter Real L(unit = "m") = 3 "Length of the tube";
parameter Real mu(unit = "kg/m.s") = 0.55*10^(-3) "Viscosity of the molten sodium";
parameter Real rho(unit = "kg/m^3") = 980 "Density of the molten sodium";
parameter Real delP(unit = "N/m^2") = 1*10^4 "Pressure drop over the length of the tube";
parameter Real delta_s_laminar(unit = "nil") = 0.5 "Distance"; //Assumed
parameter Real delta_s_buffer(unit = "nil") = 30 "Distance"; //Assumed
//=======================================================================================
//Variable Section
Real tau0(unit = "N/m^2") "Yield stress";
Real V_s(unit = "m/s") "Friction velocity";
Real delta_laminar(unit = "m") "Thickness of the laminar sublayer";
Real delta_buffer(unit = "m") "Thickness of the buffer layer";
Real actual_delta_b(unit = "m") "Actual thickness of the buffer layer";
//=======================================================================================
//Equation Section
equation
tau0 = (D*delP)/(4*L);
V_s = sqrt(tau0/rho);
delta_laminar = (delta_s_laminar*mu)/(V_s*rho);
delta_buffer = (delta_s_buffer*mu)/(V_s*rho);
actual_delta_b = delta_buffer-delta_laminar;
end Ex6_9;
