model Ex7_2
//Parameter Section
parameter Real f(unit = "nil") = 0.006 "Friction factor"; //Assumed
parameter Real V(unit = "m/s") = 4.57 "Velocity of the liquid";
parameter Real D(unit = "m") = 0.0508 "Diameter of the pipe";
parameter Real mu(unit = "N.s/m^2") = 4.46*10^(-3) "Viscosity of the fluid";
parameter Real rho(unit = "kg/m^3") = 801 "Density of the fluid";
parameter Real L(unit = "m") = 36.6 "Length of the pipe";
//==========================================================================
//Variable section
Real Re(unit = "nil") "Reynolds number";
Real Ff(unit = "J/kg") "Mechanical energy friction loss";
//==========================================================================
//Equation section
equation
Re = (D*V*rho)/mu; //The flow is turbulent
Ff = 4*f*(L/D)*(V^2/2); 
end Ex7_2;
