model Ex8_1
//Parameter Section
parameter Real MW(unit = "g/gmole") = 32 "Molecular weight of molecular oxygen";
parameter Real T(unit = "K") = 300 "Temperature of the system";
parameter Real sigma(unit = "Angstrom") = 3.433 "Lennard Jones constant";
parameter Real Cp(unit = "cal/gmol.K") = 7.019 "Heat Capacity of oxygen at 300 K";
parameter Real omega_k(unit = "nil") = 1.074 "Collision integral";
parameter Real R(unit = "cal/mol.K") = 1.9872 "Universal gas constant"; 
//====================================================================================
//Variable Section
Real mu(unit = "N.s/m^2") "Viscosity of the gas";
Real K(unit = "cal/cm.sec.K") "Thermal conductivity of the molecular oxygen";
Real k(unit = "W/m.K") "Thermal conductivity of the molecular oxygen in W/m.K";
//====================================================================================
//Equation Section
equation 
mu = (2.6693*10^(-5)*0.1*(sqrt(MW*T)))/(sigma^2*omega_k);
K = (Cp+((5*R)/(4*MW)))*mu*10^(-1);
k = (K*4.184)/(10^(-2)); // 1 cal = 4.184 J
end Ex8_1;
