model Ex9_10
//Parameter Section
parameter Real r(unit = "m") = 91.4*10^(-3) "Radius of the cylinder";
parameter Real Se(unit = "W/m^3") = 46.6 "Heat generated per unit volume";
parameter Real Tw(unit = "K") = 311 "Outer surface temperature of the cylinder";
parameter Real K(unit = "W/m.K") = 0.865 "Thermal conductivity";
//===================================================================================
//Variable Section
Real Tmax(unit = "K") "Centreline Temperature";
//===================================================================================
//Equation Section
equation
Tmax-Tw = ((Se*r^2)/(4*K));
end Ex9_10;
