model Ex9_11
//Parameter Section
  parameter Real T1(unit = "F") = 250 "Temperature of the inner surface of the cork";
  parameter Real T4(unit = "F") = 90 "Temperature of the outer surface of the cork";
  parameter Real Ks(unit = "Btu/hr.ft.F") = 26.1 "Thermal conductivity of steel";
  parameter Real Km(unit = "Btu/hr.ft.F") = 0.04 "Thermal conductivity of 85% magnesia";
  parameter Real Kc(unit = "Btu/hr.ft.F") = 0.03 "Thermal conductivity of cork";
  parameter Real d1(unit = "in") = 2.067 "Inside diameter of the steel pipe";
  parameter Real x2(unit = "in") = 0.154 "Wall thickness";
  parameter Real x3(unit = "in") = 2 "Insulation(85% magnesia) thickness";
  parameter Real x4(unit = "in") = 2 "Insulation(cork) thickness";
  //======================================================================================
  //Variable Section
  Real r1(unit = "ft") "Inside radius of the steel pipe";
  Real r2(unit = "ft") "Outside radius of the steel pipe";
  Real r3(unit = "ft") "Radius of the insulation(85% magnesia)";
  Real r4(unit = "ft") "Radius of the insulation(cork)";
  Real Q_per_L(unit = "Btu/hr.ft") "Heat loss per fppt of pipe";
  //======================================================================================
  //Equation Section
equation
  r1 = d1 / (2 * 12);
//1 ft = 12 inch
  r2 = r1 + x2 / (2 * 12);
  r3 = r2 + x3 / 12;
  r4 = r3 + x4 / 12;
  Q_per_L = 2 * 3.14 * (T1 - T4) / (1 / Ks * log(r2 / r1) + 1 / Km * log(r3 / r2) + 1 / Kc * log(r4 / r3));
end Ex9_11;
// The answer provided for r1 in the book is wrong 
