model Ex9_3
//Parameter Section
//A-PINE MATERIAL B-CORK C-CONCRETE
parameter Real KA(unit = "W/m.K") = 0.151 "Thermal conductivity of pine material";
parameter Real KB(unit = "W/m.K") = 0.0433 "Thermal conductivity of Cork";
parameter Real KC(unit = "W/m.K") = 0.762 "Thermal conductivity of Concrete";
parameter Real delxA(unit = "m") = 0.0127 "Thickness of the inner layer(pine)";
parameter Real delxB(unit = "m") = 0.1016 "Thickness of the middle layer(cork)";
parameter Real delxC(unit = "m") = 0.0762 "Thickness of the outer layer(concrete)";
parameter Real T1(unit = "K") = 255.4 "Inside temperature";
parameter Real T4(unit = "K") = 297.1 "Outside surface temperature";
parameter Real A(unit = "m^2") = 1 "Area in which heat loss occurs";
//==============================================================================
//Variable Section
Real RA(unit = "K/W") "Resistance for pine material";
Real RB(unit = "K/W") "Resistance for Cork";
Real RC(unit = "K/W") "Resistance for concrete";
Real delT(unit = "K") "Temperature driving force";
Real sigmaR(unit = "K/W") "Sum of the resistances";
Real q(unit = "W") "Rate of heat transfer";
Real T2(unit = "K") "Temperature at the interface between pine and cork";
//==============================================================================
//Equation Section
equation
RA = delxA/(KA*A);
RB = delxB/(KB*A);
RC = delxC/(KC*A);
delT = T1-T4;
sigmaR = RA+RB+RC;
q = delT/sigmaR;
T2 = T1-(q*RA);
end Ex9_3;
