//======================================================
//Thermodynamics - An Engineering approach
//Chapter-10, Vapor and combined power cycles
 //Exercise: 10.2, Page No,: 559
 // Answers are not rounded off
 //=====================================================
model Ex10_2
//Variable section
 Real qin(unit = "kJ/kg") "boiler heat input in kJ/kg";
 Real wp(unit = "kJ/kg") "pump work input in kJ/kg";
 Real wt(unit = "kJ/kg") "work output of turbine in kJ/kg";
 Real n(unit = "-") "thermal efficiency of the cycle";
 Real P(unit = "MW") "power produced by the power plant in kw";
 Real wnet(unit = "kJ/kg") "net work done in kJ/kg";
 //=====================================================
 //Parameter section
parameter Real P1(unit = "kPa") = 9 " pressure 1";
parameter Real P2(unit = "kPa") =16000 " pressure 2";
parameter Real Ep(unit = "-") =0.85 "efficiency of pump";
parameter Real Et(unit = "-") =0.87 "efficiency of turbine";
parameter Real h4(unit = "kJ/kg") =3647.6 " specific enthalpy in state 4";
parameter Real h3(unit = "kJ/kg") =160.12 "specific enthalpy in state3 ";
parameter Real h5(unit = "kJ/kg") =3583.1 "specific enthalpy in state5";
parameter Real h6(unit = "kJ/kg") =2115.32 "specific enthalpy in state6 ";
parameter Real sp(unit = "m3/kg") =0.001009 "specific volume of steam";
parameter Real m(unit = "kg/s")=15 "mass flow rate ";
 //=====================================================
 //Equation section
 equation
qin=h4-h3;
wp=sp*(P2-P1)/Ep; 
wt=Et*(h5-h6);
wnet= wt-wp;
n=wnet/qin;
P=(m*wnet)/1000;
 //=====================================================
end Ex10_2;