//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-11, Refrigeration Cycles
//Exercise: 11.4
//============================================================================
model Ex11_4
//Variable section
Real QL(unit = "kJ/kg")    "Heat removal from refrigerated space";
Real w(unit = "kW")         "Power input to the compressor";
Real COP(unit = "-")  "Coefficient of performance of refrigerator";
Real x6(unit = "-")     "Quality of refrigerant at state 6";
Real h9(unit = "kJ/kg")   "enthalpy at state 9";
//=============================================================================
// Parameters
parameter Real h1(unit = "kJ/kg") = 239.16     "enthalpy at state 1";
parameter Real h2(unit = "kJ/kg") =  255.93    "enthalpy at state 2";
parameter Real h3(unit = "kJ/kg") =  251.88   "enthalpy at state 3";
parameter Real h4(unit = "kJ/kg") = 274.48    "enthalpy at state 4";
parameter Real h6(unit = "kJ/kg") = 95.47     "enthalpy at state 6";
parameter Real h8(unit = "kJ/kg") = 55.16    "enthalpy at state 8";
parameter Real hf(unit = "kJ/kg") = 55.16    "liquid enthalpy at state 6 ";
parameter Real hfg(unit = "kJ/kg") = 196.17    "vapor enthalpy at state 6";
//=============================================================================
// Equations
equation
x6=(h6-hf)/(hfg);
QL=(1-x6)*(h1-h8);
h9=(x6*h3)+((1-x6)*h2);
w=((1-x6)*(h2-h1))+(h4-h9);
COP=QL/w;
//=============================================================================
end Ex11_4;