//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-11, Refrigeration Cycles
//Exercise: 11.6
//============================================================================
model Ex11_6
//Variable section
Real m(unit = "kg")    "Mass of the cool drinks";
Real dT(unit = "C")    "Change in temperature";
Real QC(unit = "kJ")    "Heat removed in kJ";
Real Qa(unit = "W")    "Heat removed in in dt time ";
Real w(unit = "W")    "Power consumed by the refrigerator ";
//=============================================================================
// Parameters
parameter Real rho(unit = "kg/m3") = 1     "Density of cold drinks";
parameter Real V(unit = "m3") =  0.350   "volume of cold drinks";
parameter Real dt(unit = "min")=30       "Time taken to reach the final temperature";
parameter Real COP(unit = "-")=0.1  "Coefficient of performance of refrigerator";
parameter Real Cp(unit = "kJ/kg-K")=4.186  "Specific heat of cold drinks";
parameter Real T1(unit = "C") =  4   "Temperature at state 1";
parameter Real T2(unit = "C") = 20    "Temperature at state 2";
//=============================================================================
// Equations
equation
m=rho*V;
dT=(T2-T1);
QC=m*Cp*dT;
Qa=QC*1000/(dt*60);
w=(Qa/COP);
//=============================================================================
end Ex11_6;