//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-12, Thermodynamic Property Relations
//Exercise: 12.1
//============================================================================
model Ex12_1
//Variable section
Real dt(unit = "K")        "Change in Temperature";
Real dh(unit = "kj/kg")    "Change in Enthalpy";
Real Cp(unit = "kj/kg K")  "Specific Heat";
//=============================================================================
// Parameters
parameter Real T1(unit ="K") = 305              "Temperature 1";
parameter Real T2(unit ="K")  =295              "Temperature 2";
parameter Real h_T1(unit = "kj/kg") = 305.22    "Enthalpy at Temperature 1";
parameter Real h_T2(unit = "kj/kg") = 295.17    "Enthalpy at Temperature 2";

//=============================================================================
// Equations
equation
dt=T1-T2;
dh=h_T1-h_T2;
Cp= dh/dt;
end Ex12_1;
//=============================================================================