//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-12, Thermodynamic Property Relations
//Exercise: 12.5
//============================================================================
model Ex12_5
//Variable section
Real Ta(unit = "K")        "Average Temperature";
Real Vfg(unit = "m3/kg")    "specific volume (Vfg) at 20 deg C";
Real dt(unit = "deg C")     "Change in Temperature";
Real hfg(unit = "kj/kg")    " Enthalpy of vaporization";
Real dp(unit = "kPa")       "Change in pressure";
//=============================================================================
// Parameters
parameter Real T1(unit ="deg C") = 24            "Temperature 1";
parameter Real T2(unit ="deg C")  = 16              "Temperature 2";
parameter Real p1(unit ="kPa") = 646.18        "Saturated Pressure at 24 deg C";
parameter Real p2(unit ="kPa")  = 504.58          "Saturated Pressure at 16 deg C";
parameter Real Vg(unit = "m3/kg") = 0.035969    "Specific volume at Temperature Ta";
parameter Real Vf(unit = "m3/kg") = 0.0008161    "Specific volume at Temperature Ta";

//=============================================================================
// Equations
equation
Ta=((T1+T2)/2)+273.15;
dt=T1-T2;
Vfg=Vg-Vf;
dp=p1-p2;
hfg= Ta*Vfg*(dp/dt);
//=============================================================================

end Ex12_5;