//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-13, Gas Mixtures
//Exercise: 13.4
//============================================================================
model Ex13_4
//Variable section
Real N(unit = "kmol")    "Total number of Moles of mixture in the tank";
Real xCO2(unit = "-")    "Mole fraction of CO2 in tank";
Real xO2(unit = "-")    "Mole fraction of O2 in tank";
Real DelS(unit = "kJ/K") "Entropy change due to mixing";
Real Ex(unit = "MJ")    "Exergy destruction";
//=============================================================================
// Parameters
parameter Real NCO2(unit = "kmol")=5    "Moles of CO2 in tank";
parameter Real NO2(unit = "kmol") =3   "Moles of O2 in tank";
parameter Real R(unit = "kJ/kmol-K") =8.314   "Universal gas constant";
parameter Real T(unit = "K") =298   "Temperature of the gases";
//=============================================================================
// Equations
extends Modelica.Math;
equation
N=NCO2+NO2;
xCO2=NCO2/N;
xO2=NO2/N;
DelS=-R*((NCO2*log(xCO2))+(NO2*log(xO2)));
Ex=DelS*T/1000;
//"The answer may slightly vary due to roundoff error"
//=============================================================================
end Ex13_4;