//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-14, Gas-vapor mixtures and Air conditioning
//Exercise: 14.6
//============================================================================
model Ex14_6
//Variable section

Real ma(unit = "kg/min")   "mass flow rate of dry air";
Real mw(unit = "kg/min")   "mass flow rate of moisture removal";
Real Q(unit = "kJ/min")   "Rate of heat removal";
//=============================================================================
// Parameters
parameter Real h1(unit = "kJ/kg") = 85.4 "Enthalpy at inlet";
parameter Real h2(unit = "kJ/kg") = 39.3 "Enthalpy at outlet";
parameter Real h3(unit = "kJ/kg") = 58.8 "Enthalpy at saturated liquid water at 14 deg C";
parameter Real W1(unit = "kg H2O/kg dry air") =0.0216   "Specific humidity at state1";
parameter Real W2(unit = "kg H2O/kg dry air") = 0.01  "Specific humidity at state2";
parameter Real Sv(unit = "m3/kg dry air") = 0.889  "Specific volume at state 1";
parameter Real V(unit = "m3") = 10  "Total volume of air enters the room";
//=============================================================================
// Equations
equation
ma=V/Sv;
mw=ma*(W1-W2);
Q=(ma*(h1-h2))-(mw*h3);
//"The answer may vary due to round off error"
//=============================================================================
end Ex14_6;