//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-14, Gas-vapor mixtures and Air conditioning
//Exercise: 14.9
//============================================================================
model Ex14_9
//Variable section

Real ma(unit = "kg/s")   "mass flow rate of dry air";
Real mw(unit = "kg/s")   "mass flow rate of moisture removal";
Real V(unit = "m3/s")   "Total volumetric flow rate of air enters the tower";
//=============================================================================
// Parameters
parameter Real h1(unit = "kJ/kg") = 42.2 "Enthalpy at inlet";
parameter Real h2(unit = "kJ/kg") = 100 "Enthalpy at outlet";
parameter Real h3(unit = "kJ/kg") = 92.28 "Enthalpy at saturated liquid water at 22 deg C";
parameter Real h4(unit = "kJ/kg") = 146.64 "Enthalpy at saturated liquid water at 35 deg C";
parameter Real W1(unit = "kg H2O/kg dry air") =0.0087   "Specific humidity at state1";
parameter Real W2(unit = "kg H2O/kg dry air") = 0.0273  "Specific humidity at state2";
parameter Real Sv(unit = "m3/kg dry air") = 0.842  "Specific volume at state 1";
parameter Real m2(unit = "kg/s") =100  "mass flow rate of cooling water";
//=============================================================================
// Equations
equation
ma=(m2*(h4-h3))/((h2-h1)-((W2-W1)*h3));
V=ma*Sv;
mw=ma*(W2-W1);
//"The answer may vary due to round off error"
//=============================================================================
end Ex14_9;