//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-15, Chemical Reactions
//Exercise: 15.9
//============================================================================
model Ex15_9
//Variable section
Real Wr(unit = "BTU")   "Reversible work";
//=============================================================================
// Parameters
parameter Real Gf_C(unit = "BTU/lbmol") =0   "Gibbs function of formation of Carbon";
parameter Real Gf_O2(unit = "BTU/lbmol") =0   "Gibbs function of formation of Oxygen";
parameter Real Gf_CO2(unit = "BTU/lbmol") =-169680   "Gibbs function of formation of Carbon dioxide";
parameter Real N_C(unit = "lbmol") = 1 "Moles of C";
parameter Real N_O2(unit = "lbmol") =1  "Moles of O2";
parameter Real N_CO2(unit = "lbmol")= 1  "Moles of CO2";
//=============================================================================
// Equations
equation
Wr=(N_C* Gf_C)+(N_O2* Gf_O2)-(N_CO2* Gf_CO2);
//=============================================================================
end Ex15_9;