//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-16, Chemical and Phase Equilibrium
//Exercise: 16.11
//============================================================================
model Ex16_11
//Variable section
Real Pv_H2O(unit = "kPa")    "Saturation pressure of H20";
Real Pv_NH3(unit = "kPa")     "Saturation pressure of H20";
Real Pt(unit = "kPa")  "Total pressure of the mixture";
Real Y_NH3(unit = "-")  "Molfraction of NH3 in gas phase";
Real Y_H2O(unit = "-")  "Molfraction of H20 in gas phase";
//=============================================================================
// Parameters
parameter Real T(unit = "C")  = 40 "Temperature of NH3-H2O mixture";
parameter Real X_NH3(unit = "-")  = 0.7 "Molfraction of NH3 in liquid phase";
parameter Real X_H2O(unit = "-")  = 0.3 "Molfraction of H20 in liquid phase";
parameter Real Ps_H2O(unit = "kPa")  = 7.3851  "Saturation pressure of H20";
parameter Real Ps_NH3(unit = "kPa")  = 1554.33   "Saturation pressure of NH3";
//=============================================================================
// Equations
equation
Pv_NH3= (X_NH3*Ps_NH3);
Pv_H2O=(X_H2O*Ps_H2O);
Pt=Pv_H2O+Pv_NH3;
Y_NH3=Pv_NH3/Pt;
Y_H2O=Pv_H2O/Pt;
//=============================================================================
end Ex16_11;