package Ex16_6
//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-16, Chemical and Phase Equilibrium
//Exercise: 16.6a
//============================================================================
model Ex16_6_a
//Variable section
Real H_R(unit = "kJ/kmol")    "Enthalpy of raection for combustion process";
//=============================================================================
// Parameters
parameter Real Hf1(unit = "kJ/kmol")  = 0 "Enthalpy of formation of H2";
parameter Real Hr1(unit = "kJ/kmol")  =61400  "Enthalpy of H2 at room temperature ";
parameter Real Hc1(unit = "kJ/kmol") = 8468   "Enthalpy of H2 at Combustion temperature ";
parameter Real Hf2(unit = "kJ/kmol") = 0   "Enthalpy of formation of O2";
parameter Real Hr2(unit = "kJ/kmol") = 67881   "Enthalpy of O2 at room temperature ";
parameter Real Hc2(unit = "kJ/kmol") =8682   "Enthalpy of O2 at Combustion temperature ";
parameter Real Hf3(unit = "kJ/kmol")  = -241820  "Enthalpy of formation of H2O";
parameter Real Hr3(unit = "kJ/kmol")  = 82593  "Enthalpy of H2O at room temperature ";
parameter Real Hc3(unit = "kJ/kmol")  =9904  "Enthalpy of H2O at Combustion temperature ";
parameter Real Sc_H2O(unit = "-")= 1    "Stoichiometric coefficeient of H2O";
parameter Real Sc_H2(unit = "-") =1    "Stoichiometric coefficeient of H2";
parameter Real Sc_O2(unit = "-") =0.5   "Stoichiometric coefficeient of O2";
//=============================================================================
// Equations
equation
H_R= (Sc_H2O*(Hf3+Hr3-Hc3))-(Sc_H2*(Hf1+Hr1-Hc1))-(Sc_O2*(Hf2+Hr2-Hc2));
 //"The answer may slightly different due to roundoff error";
//=============================================================================
  end Ex16_6_a;

//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-16, Chemical and Phase Equilibrium
//Exercise: 16.6b
//============================================================================
model Ex16_6_b
//Variable section
Real H_R(unit = "kJ/kmol")    "Enthalpy of raection for combustion process";
//=============================================================================
// Parameters
parameter Real R(unit = "kJ/kmol-K")  = 8.314 "Universal gas constant";
parameter Real T1(unit = "K")  = 1800  "Temperature at point 1";
parameter Real T2(unit = "K")  = 2200  "Temperature at point 2";
parameter Real Kp1(unit = "-")  =18509  "Equilibrium constant 1 ";
parameter Real Kp2(unit = "-")  =869.6  "Equilibrium constant 2 ";
//=============================================================================
// Equations
extends Modelica.Math;
equation
H_R= ((log(Kp2/Kp1))*8.314)/((1/T1)-(1/T2));
//=============================================================================
end Ex16_6_b;
end Ex16_6;
