//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-16, Chemical and Phase Equilibrium
//Exercise: 16.9
//============================================================================
model Ex16_9
//Variable section
Real Ya_liq(unit = "-")    "Mole fraction of dry air in liquid side";
Real P_da(unit = "bar")  "Partial pressure  of dry air at surface of the lake";
//=============================================================================
// Parameters
parameter Real T(unit = "C")  = 17  "Temperature";
parameter Real Pv(unit = "kPa")  = 1.96  "Saturation pressure of water at Temperature T";
parameter Real P(unit = "kPa")  = 92  "Atmospheric pressure at lake level";
parameter Real H(unit = "-")  =62000   "Henry constant of air dissolved in lake at T";
//=============================================================================
// Equations
equation
P_da=(P-Pv)/100;
Ya_liq= P_da/H;
//=============================================================================
end Ex16_9;