//======================================================
//Thermodynamics - An Engineering approach
//Chapter-02, Energy, Energy transfer, and general energy analysis
//Exercise: 2.16, Page No: 84
//Title: Energy balance
//=====================================================
class Ex2_16
//Variable section
Real E(unit = "kJ/Kg") "Change in mechanical energy";
Real E_1(unit = "kW") "Rate at which mechanical energy is supplied to the turbine in kW";
Real n_1 "Overall efficiency";
Real n_3 "Efficiency of turbine";
Real W(unit = "kW") "Output shaft power";
//=====================================================
//Parameter section
parameter Real E_2(unit = "kW") = 1862 "Electric power generated in kW";
parameter Real n_2= 0.95 "Efficiency of generator";
parameter Real g(unit = "m/s2") = 9.81 "Acceleration due to gravity";
parameter Real h(unit = "m") = 50 "Depth of lake";
parameter Real m(unit = "Kg/s") = 5000 "Mass flow rate of water";
//=====================================================
//Equation section
equation
E = (g*h)/1000;
E_1 = E*m;
n_1 = E_2/E_1;
n_3 = n_1/n_2;
W = n_3*E_1;
//======================================================
end Ex2_16;