//======================================================
//Thermodynamics - An Engineering approach
//Chapter-02, Energy, Energy transfer, and general energy analysis
//Exercise: 2.2, Page No: 59 
//Title: wind energy 
//=====================================================
package Ex2_2
  class Ex2_2a
  //========================================================
  //Variable section
  Real E(unit = "J/Kg") "Wind energy per unit mass of air";
  //========================================================
  //Parameter section
  parameter Real v(unit = "m/s") = 8.5 "Wind speed";
  //========================================================
  //Equation section
  equation
  E = (v^2)/2;
  //========================================================
  end Ex2_2a;

  class Ex2_2b
  //========================================================
  //Variable section
  Real E_1(unit = "J") "Wind energy for an air of mass 10 Kg";
  //========================================================
  //Parameter section
  parameter Real m(unit = "Kg") = 10 "Mass of air";
  parameter Real e(unit = "J/Kg") = 36.1 "Energy";
  //========================================================
  //Equation section
  equation
  E_1 = (m*e);
  //========================================================
  
  end Ex2_2b;

  class Ex2_2c
  //========================================================
  //Variable section
  Real E_2(unit = "kW") "Wind energy for a mass flowrate of 1154 Kg/s";
  //========================================================
  //Parameter section
  parameter Real m1(unit = "Kg/s") = 1154 "Mass of air";
  parameter Real e1(unit = "J/Kg") = 36.1 "Energy";
  //========================================================
  //Equation section
  equation
  E_2 = (m1*e1)/1000;
  //1000 is divided to convert units from W to kw
  //========================================================
  end Ex2_2c;
end Ex2_2;
