//============================================================================
//Thermodynamics - An Engineering approach
//Chapter-3, Properties of pure substances
//Exercise: 3.3
//============================================================================
model Ex3_3
//Variable section
Real vfg(unit = "m3/kg")      "Specific volume";
Real Q(unit = "kj")      "Energy transfered";
Real Dv(unit = "m3")    "Change in total volume ";
//=============================================================================
// Parameters
parameter Real m(unit = "kg") = 0.2    "Total mass of the the saturated liquid";
parameter Real vf(unit = "m3/kg") = 0.001043     "Liquid Specific volume at 100kPa";
parameter Real vg(unit = "m3/kg") = 1.6941    "Vapour Specific volume at 100kPa";
parameter Real hfg(unit = "kj/kg") = 2257.5   "Enthalpy at 100kPa";
//=============================================================================
// Equations
equation
vfg= vg-vf;
Dv=m*vfg;
Q= m*hfg;
//=============================================================================
end Ex3_3;