package Ex4_10
  class Ex4_10_a
    //Variable section
    Real T_3(unit = "K") "Final temperature in K";
    //=====================================================
    //Parameter section
    parameter Real T_1(unit = "deg.C") = 27 "Temperature of air in deg.C";
    parameter Real P_1(unit = "kPa") = 150 "Initial temperature of air";
    parameter Real P_3(unit = "kPa") = 350 "Final pressure";
    //=====================================================
    //Equation section
  equation
    T_3 = 2 * P_3 * (T_1 + 273.15) / P_1;
//As intial volume is half of final volume 2 is multiplied
//273.15 is added to convert temperature from deg.C to K
  end Ex4_10_a;

  class Ex4_10_b
    //=====================================================
    //Variable section
    Real Area(unit = "m3.kPa") "Area";
    Real W_13(unit = "kJ") "Workdone by the system";
    //=====================================================
    //Parameter section
    parameter Real del_V(unit = "m3") = 0.4 "Volume";
    parameter Real P_2(unit = "kPa") = 350 "Pressure in kPa";
    //=====================================================
    //Equation section
  equation
    Area = P_2 * del_V;
    W_13 = 140;
//the area under the process curve on a P-V diagram, shown in Fig. 4–3
  end Ex4_10_b;

  //=====================================================

  class Ex4_10_c
  //=====================================================
  //Variable section
  Real m(unit = "Kg") "Mass in Kg";
  Real Q_in(unit = "kJ") "Energy in kJ";
  //=====================================================
  //Parameter section
  parameter Real T_1(unit = "deg.C") = 27 "Temperature of air in deg.C";
  parameter Real P_1(unit = "kPa") = 150 "Initial temperature of air";
  parameter Real V_1(unit = "m3") = 0.4 "Volume";
  parameter Real u_1(unit = "kJ/Kg") = 214.07 "Internal energy at 300K";
  parameter Real u_3(unit = "kJ/Kg") = 1113.52 "Internal energy at 1400K";
  parameter Real R(unit = "kPa.m3/Kg.K") = 0.287 "Universal gas constant"; 
  parameter Real W_13(unit = "kJ/Kg") = 140 "Workdone in kJ";
  //the area under the process curve on a P-V diagram, shown in Fig. 4–32
  //=====================================================
  //Equation section
  equation
  m = (P_1*V_1)/(R*(T_1+273));
  //273.15 is added to convert deg.C to K
  Q_in = (m*(u_3 - u_1))+W_13;
  end Ex4_10_c;
end Ex4_10;
