//======================================================
//Thermodynamics - An Engineering approach
//Chapter-04, Energy analysis of closed circuit
//Exercise: 4.5, Page No: 174
//Title : Polytropic process
//====================================================
class Ex4_5
//Variable section
Real We(unit = "kJ") "Work done";
Real h_2(unit = "kJ/Kg") "Final enthalpy in kJ/Kg"; 
Real T_2(unit = "deg.C") "Final temperature";
//=====================================================
//Parameter section
parameter Real I(unit = "A") = 0.2 "Current in ampere";
parameter Real V(unit = "V") = 120 "Voltage";
parameter Real t(unit = "s") = 300 "Time taken in seconds";
parameter Real P_1(unit = "kPa") = 400 "Intial presure";
parameter Real V_1(unit = "m3") = 0.5 "Volume";
parameter Real R(unit = "")= 0.297 "Gas constant";
parameter Real T_1(unit = "K") = 300 "Temperature";
parameter Real m(unit = "Kg") =0.025 "Mass in Kg";
parameter Real h_1(unit = "kJ/Kg") = 2724.9 "Intial enthalpy in kJ/Kg";
parameter Real Q_out(unit = "kJ") = 3.7 "Heat load";
//=====================================================
//Equation section
equation
We=V*I*t /1000;
h_2 = ((We-Q_out)/m)+h_1;
T_2 = 200; //Temperature is taken based on value of h_2 from Table A_6
//==================================================
end Ex4_5;