//Thermodynamics - An Engineering approach
//Chapter-05, Mass and energy analysis of control volumes
//Exercise: 5.2, Page No: 226
//Title : Flow work and the energy of a flowing fluid
//=========================================================
model Ex5_2
//Variable section 
Real t(unit = "sec") "Time taken for water level to fall to half of its initial value in seconds";
Real t1(unit = "min") "Time taken for water level to fall to half of its initial value in minutes";
//=========================================================
//parameter section
parameter Real h0(unit = "ft") =4 "height of cylindrical water tank in f t";
parameter Real h2(unit = "ft") =2 "final water level in tank in ft";
parameter Real g(unit = "ft/s2") =32.2  "aceleration due to gravity in ft / s^2";
parameter Real Dt(unit = "in") =36 " diameter of tank in inches";
parameter Real Djet(unit = "in") =0.5 "Diameter of water jet in inches";
//=========================================================
//Equation section
equation
t = ( h0 ^0.5 - h2 ^0.5) *( Dt) ^2/(( Djet ) ^2*( g/2) ^0.5);
t1 = t/60;
//60 is divided to convert to seconds to minutes
//=========================================================
end Ex5_2;