//Thermodynamics - An Engineering approach
//Chapter-05, Mass and energy analysis of control volumes
//Exercise: 5.6, Page No: 236
//Title : Turbines and compressors
//==========================================================
class Ex5_6
//Variable section 
  Real W_in(unit = "kJ/s") "Power input to compressor";
  //=========================================================
  //parameter section
  parameter Real m(unit = "Kg/s") = 0.02  "Mass flowrate of air";
  parameter Real q_out(unit = "kJ/Kg") = 16 "Heat loss during process";
  parameter Real h_2(unit = "kJ/Kg") = 280.13 "Enthalpy at temperature 280K";
  parameter Real h_1(unit = "kJ/Kg") = 400.98   "Enthalpy at temperature 400K";
    //=========================================================
  //Equation section
  equation
W_in = m*q_out + (m*(h_1 - h_2));
  //=========================================================
end Ex5_6;