//======================================================
//Thermodynamics - An Engineering approach
//Chapter-06, The second law of thermodynamics
//Exercise: 6.3, Page No: 291
//Title : Refrigeration and heat pumps
//=======================================================
package Ex6_3
  class Ex6_3_a
  //=======================================================
  //Variable section 
  Real COP_Re "Coefficient of performance for refrigerator";
  //=======================================================
  //Parameter section
  parameter Real Q_L(unit = "kJ/min") = 360 "Rate of heat removed";
  parameter Real W_net_in(unit = "kW") = 2 "Power input of the refrigerator";
  //=======================================================
  //Equation section
  equation
  COP_Re = Q_L/(W_net_in*60);
  //60 is divided to convert minutes to seconds
  //=======================================================
  end Ex6_3_a;

  class Ex6_3_b
  //=======================================================
  //Variable section 
  Real Q_H(unit = "kJ/min") "Rate of rejection to the room that houses the refrigerator";
  //=======================================================
  //Parameter section
  parameter Real Q_L(unit = "kJ/min") = 360 "Rate of heat removed";
  parameter Real W_net_in(unit = "kW") = 2 "Power input of the refrigerator";
  //=======================================================
  //Equation section
  equation
  Q_H = Q_L + (W_net_in*60);
  //60 is multiplied to convert seconds to minutes
  //=======================================================
  end Ex6_3_b;
end Ex6_3;
