//======================================================
//Thermodynamics - An Engineering approach
//Chapter-06, The second law of thermodynamics
//Exercise: 6.7, Page No: 310
//Title : The carnot refrigerator and heat pump
//=======================================================
model Ex6_7
//=======================================================
//Variable section 
Real COP_HP_rev "Coefficient of performance of Heat pump";
Real W_net_in(unit = "kW") "Power input to reversible process";
//=======================================================
//Parameter section
parameter Real T_L(unit = "deg.C") = -5 "Outside temperature drop";
parameter Real T_H(unit = "deg.C") = 21 "House temperature";
parameter Real Q_H(unit = "kW") = 37.5 "Heat rate to house in kW";
//=======================================================
//Equation section
equation
COP_HP_rev = 1/(1-((T_L+273)/(T_H+273)));
W_net_in = Q_H/COP_HP_rev;
//273 is added to convert deg.C to Kelvin
//=======================================================
end Ex6_7;