// Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.8, Page No: 353
//Title: Economics of replacing a valve by turbine
//================================================================
model Ex7_10
//Variable Section
Real vr_2 "Relative specific volume";
Real T_2(unit = "K") "Temperature at relative specific volume vr_2";
Real T2(unit = "K") " Final Temperature of air ";
//================================================================
// Parameter Section
parameter Real T1(unit ="deg.C") = 22 " initial Temperature of air ";
parameter Real x = 8 " compression ratio V1/V2 ";
parameter Real vr_1(unit = "") = 647.9 "Relative specific volume at temperature 295 K from table A-17";
parameter Real K(unit ="") = 1.391 " K value at average temperature ";
//================================================================
// Equation Section
equation
vr_2 = (1/x)*vr_1;
T_2 = 662.7;
T2 = (T1+273)*x^(K-1);
//273 is added to convert from deg.C to K
end Ex7_10;