//===================================================
//Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.14, Page No: 372
//Title: Isentropic efficiencies of turbines 
//===================================================
package Ex7_14
class Ex7_14_a
//=================================================
//Variable section
Real x2s "quality at state 2";
Real h_2s(unit = "kJ/Kg") "Enthalpy";
Real eta_T_1 "Isentropic effciency of turbine";
Real eta_T(unit = "%") "Isentropic effciency of turbine";
//=================================================
//Parameter section
parameter Real h1(unit = "kJ/Kg") = 3231.7 " Enthalpy at 3000kpa ";
parameter Real h2(unit = "kJ/Kg") = 2682.4 " Enthalpy at 50kpa ";
parameter Real P1(unit = "kPa ") = 3000 " inlet pressure of steam";
parameter Real P2(unit = "kPa ") = 50 " oulet pressure of steam";
parameter Real T1(unit = "K") = 400 " inlet temperature ";
parameter Real T2(unit = "K") = 100 " oulet temperature ";
parameter Real s1(unit = "kJ/Kg.K") = 6.9235 " Entropy at initial state";
parameter Real s2(unit = "kJ/Kg.K") = 1.0912 " Entropy at final state";
parameter Real s2g(unit = "kJ/Kg.K") = 6.5019 " Entropy at final state at saturated mixture";
parameter Real h2f(unit = "kJ/Kg") = 2304.7 " Enthalpy at fin?al state at saturated mixture";
parameter Real hf(unit = "kJ/Kg") = 340.54 " Enthalpy at final state ";
//==================================================
//Equation section
equation
x2s = (s1 - s2)/s2g;
h_2s = hf + (x2s*h2f);
eta_T_1 = ((h1 - h2)/(h1 - h_2s));
eta_T = eta_T_1*100;

end Ex7_14_a;

  class Ex7_14_b
  
  //=================================================
  //Variable section
  Real m(unit = "Kg/s") "Mass flowrate of steam through this turbine";
  
  //=================================================
  //Parameter section
  parameter Real h1(unit = "kJ/Kg") = 3231.7 " Enthalpy at 3000kpa ";
  parameter Real h2(unit = "kJ/Kg") = 2682.4 " Enthalpy at 50kpa ";
  parameter Real P(unit = "MW") = 2 "Power";
  parameter Real E(unit = "kJ/s") = 1000 "Energy";
  
  //=================================================
  //Equation section
  equation
  m = (P*E/(h1 - h2));
  
  end Ex7_14_b;
end Ex7_14;
