//===================================================
//Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.17, Page No: 382
//Title: Entropy Balance
//===================================================
class Ex7_17
//===================================================
//Variable Section
Real S_gen_wall(unit = "W/K") " the rate of entropy generation in the wall";
Real S_gen_total(unit = "W/K") " the rate of total entropy generation associated with this heat transfer process ";
//===================================================
// Parameter Section
parameter Real T1(unit = "deg.C") = 20 " The temperatures of the inner surfaces of the brick wall ";
parameter Real T2(unit = "deg.C") = 5 " The temperatures of the outer surfaces of the brick wall ";
parameter Real T3(unit = "deg.C") = 27 " The temperatures of the surrounding surfaces of the brick wall ";
parameter Real T4(unit = "deg.C") = 0 " The temperatures of the  surfaces of the brick wall ";
parameter Real Q(unit = "W") = 1035 " the rate of heat transfer through the wall";
//===================================================
// Equation Section
equation
S_gen_wall = (Q/(T2+273))-(Q/(T1+273));
S_gen_total = (Q/(T4+273))-(Q/(T3+273));
//273 is added to convert deg.C to K
end Ex7_17;