//========================================================
//Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.21, Page No: 387
//Title: Entropy Generation in a Mixing Chamber
//========================================================
class Ex7_21
//========================================================
//Variable Section
Real del_S_sys(unit = "kJ/K") " the entropy change of the water";
Real S_gen(unit = "kJ/K") " the total entropy generation during this heat transfer process";
//========================================================
// Parameter Section
parameter Real T_sys(unit = "deg.C") = 100 " cylinder temperature ";
parameter Real Tb(unit = "deg.C") = 25 " surrounding temperature ";
parameter Real Q_out(unit = "kJ") = -600 " heat transferred to the surrounding";
//=========================================================
// Equation Section
equation
del_S_sys = Q_out/(T_sys+273);
S_gen = (-Q_out/(Tb+273))+del_S_sys;
//273 is added to convert deg.C to kelvin
end Ex7_21;