//======================================================
//Thermodynamics- An Engineering Approach
// Chapter - 07, Entropy
// Exercise: 7.23, Page No: 398
//Title: Reducing the Pressure Setting to Reduce Cost
//======================================================
model Ex7_23
//======================================================
//Variable Section
Real cost_savings(unit = "$/yr") " the cost saved per year";
Real f_red;
Real x;
//======================================================
// Parameter Section
parameter Real P1(unit = "kPa ") = 85.6 " atmosperic pressure";
parameter Real P2(unit = "kPa ") = 985.6 " compressed pressure";
parameter Real P2_red(unit = "kPa ") = 885.6 "Reduced pressure";
parameter Real n = 1.4 "Number of stages ";
parameter Real cost(unit = "$/yr") = 12000 " current cost ";
//======================================================
// Equation Section
equation
x = (n-1)/n;
f_red = 1-((((P2_red/P1)^x)-1)/(((P2/P1)^x)-1));
cost_savings = cost*f_red;
end Ex7_23;