//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.16, Page No: 462
//Title : Second law efficiency of steady flow devices
 //=======================================================
class Ex8_16
//=======================================================
  //Variable section
    Real W_rev_out(unit = "Btu/min") "Reversible work";
    Real X_destroyed(unit = "Btu/min") "Energy destroyed";
    Real Xdestroyed(unit = "Btu/min") "Energy destroyed";
  //=======================================================
  //Parameter section
  parameter Real m1(unit = "lbm/min") = 300 "Mass flow rate of water at entry of mixing chamber";
  parameter Real h1(unit = "Btu/lbm") = 18.07 "Enthalpy of water at entry of mixing chamber";
  parameter Real S1(unit = "Btu/lbm.R") = 0.03609 "Entropy of water at entry of mixing chamber";
   parameter Real m2(unit = "lbm/min") = 22.7 "Mass flow rate of steam";
  parameter Real h2(unit = "Btu/lbm") = 1162.3 "Enthalpy of steam";
  parameter Real S2(unit = "Btu/lbm.R") = 1.7406 "Entropy of steam";
  parameter Real m3(unit = "lbm/min") = 322.7 "Mass flowrate";
  parameter Real h3(unit = "Btu/lbm") = 97.99 "Enthalpy";
  parameter Real S3(unit = "Btu/lbm.R") = 0.18174 "Entropy";
  parameter Real To(unit = "deg.C") = 70 "Temperature of heat loss to surrounding air";
  parameter Real S_gen(unit = "Btu/min.R") = 8.65 "Entropy generated";
   //=======================================================
  //Equation section
equation
W_rev_out = m1*(h1 - ((To+460)*S1)) + m2*(h2 - ((To+460)*S2)) - m3*(h3 - ((To+460)*S3));
X_destroyed = W_rev_out;
Xdestroyed = S_gen*(To+460);
//460 is added to convert deg.C to R
//=======================================================
end Ex8_16;