//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.2, Page No: 427
//Title :  Energy: work potential of energy
//=======================================================
class Ex8_2
//=======================================================
//Variable section 
Real eta_th_1 "Thermal efficicency of reversible heat engine";
Real eta_th(unit = "%") "Thermal efficicency of reversible heat engine";
Real W_rev(unit = "Btu/s") "Power produced by reversible heat engine";
//=======================================================
//Parameter section
parameter Real T_O(unit = "deg.F") = 77 "Environment Temperature";
parameter Real T_H(unit = "R") = 2000 "Temperature of furnace";
parameter Real Q_in(unit = "Btu/s") = 3000 "Rate in Btu/s";
//=======================================================
//Equation section
equation
eta_th_1 = 1-((T_O+460)/T_H);
//460 is added to convert deg.F to Rankine
eta_th = eta_th_1*100;
W_rev = Q_in*eta_th_1;
//=======================================================
end Ex8_2;