//======================================================
//Thermodynamics - An Engineering approach
//Chapter-08, Energy: A measure of work potential
//Exercise: 8.4, Page No: 429
//Title :  Reversible work and Irreversibility
//=======================================================
class Ex8_4
//=======================================================
//Variable section 
Real W_rev(unit = "kJ") "Amount of power of reversible heat engine";
Real T_0(unit = "K") "Temperature of surroundings in Kelvin";
Real T_1(unit = "K") "Temperature of source in Kelvin";
Real I(unit = "kJ") "Irreversibility in work";
//=======================================================
//Parameter section
parameter Real m(unit = "Kg") = 500 "Mass of iron block";
parameter Real T0(unit = "deg.C") = 27 "Temperature of surroundings";
parameter Real T1(unit = "deg.C") = 200 "Temperature of source";
parameter Real c_avg(unit = "kJ/Kg.K") = 0.45 "Average specific heat";
parameter Real W_u(unit = "kJ") = 0 ;
//=======================================================
//Library section
extends Modelica.Math;
//=======================================================
//Equation section
equation
T_0 = T0 + 273;
T_1 = T1 + 273;
//273 is added to convert deg.C to Kelvin
W_rev = (m*c_avg*((T_1 - T_0) - (T_0*(log(T_1/T_0)))));
I = W_rev - W_u;
//=======================================================
end Ex8_4;