//======================================================
//Thermodynamics - An Engineering approach
//Chapter-09, Gas power cycles
//Exercise: 9.3, Page No: 502
//Title : Diesel cycle: The ideal cycle for compression-ignition engines
 //=======================================================
package Ex9_3
  class Ex9_3_a
  //=======================================================
    //Variable section
      Real V2(unit = "in3") "Volume of process 1-2";
      Real V3(unit = "in3") "Volume of process 2-3";
      Real V4(unit = "in3") "Volume of process 3-4";
      Real T2(unit = "R") "Temperature for process 1-2 i.e., isentropic compression of an ideal gas";
      Real P2(unit = "psia") "Pressure of process 1-2";
      Real P3(unit = "psia") "Pressure of process 2-3";
      Real T3(unit = "R") "Temperature for process 2-3";
      Real T4(unit = "R") "Temperature for process 3-4";
       Real P4(unit = "psia") "Pressure at process 3-4";   
    //=======================================================
    //Parameter section
    parameter Real r = 18 "Compression ratio = V1/V2";
    parameter Real rc = 2;
    parameter Real T1(unit = "F") = 80 "Temperature at point 1";
    parameter Real V1(unit = "in3") = 117 "Volume for process 1-2";
    parameter Real P1(unit = "psia") = 14.7 "Pressure at process 1-2";
    parameter Real k = 1.4 "k value for isentropic process";
    //=======================================================
    //Equation section
  equation
  V2 = V1/r;
  V3 = rc*V2;
  V4=V1;
  T2 = (T1+460)*((V1/V2)^(k-1));
  P2 = P1*((V1/V2)^k);
  P3 = P2;
  T3 = T2*(V3/V2);
  T4 = T3*((V3/V4)^(k-1));
  P4 = P3*(V3/V4)^k;
  //=======================================================
  end Ex9_3_a;

  class Ex9_3_b
  //=======================================================
    //Variable section
      Real m(unit = "lbm") "Mass of air";
      Real Q_in(unit = "Btu") "Heat addtion for process 2-3";
      Real Q_out(unit = "Btu") "Amount of heat rejected for process 2-3";
      Real W_net(unit = "Btu") "Net work";
      Real eta_th "Thermal efficiency";
      Real eta_th_1(unit = "%") "Thermal efficiency";
     //=======================================================
    //Parameter section
    parameter Real P1(unit = "psia") = 14.7 "Pressure at process 1-2";
    parameter Real T1(unit = "F") = 80 "Temperature at process 1-2";
    parameter Real V1(unit = "in3") = 117 "Volume for process 1-2";
    parameter Real Cp(unit = "Btu/lbm.R") = 0.24 "Specific heat";
    parameter Real Cv(unit = "Btu/lbm.R") = 0.171 "Specific heat at constant volume";
    parameter Real T2(unit = "R") = 1716 "Temperature at process 2-3";
    parameter Real T3(unit = "R") = 3432 "Temperature at process 3-4";
    parameter Real T4(unit = "R") = 1425 "Temperature at process 4-1";
    parameter Real R(unit = "psia.ft3/lbm.R") = 0.3704 "Universal gas constant";
    //=======================================================
    //Equation section
  equation
  m = P1*V1/(R*(T1+460))*(1/1728);
  Q_in = m*Cp*(T3-T2);
  Q_out = m*Cv*(T4-(T1+460));
  //460 is added to convert F to R
  W_net = Q_in - Q_out;
  eta_th = W_net/Q_in;
  eta_th_1 = eta_th*100;
  //=======================================================
  end Ex9_3_b;

  class Ex9_3_c
  //=======================================================
    //Variable section
      Real MEP(unit = "psia") "Mass effective pressure";
    //=======================================================
    //Parameter section
    parameter Real W_net(unit = "Btu") = 1.297 "Net work done";
    parameter Real V1(unit = "in3") = 117 "Volume for process 1-2";
    parameter Real V2(unit = "in3") = 6.5 "Volume of process 1-2";
    //=======================================================
    //Equation section
  equation
  MEP = (W_net/(V1 - V2))*778.17*12;
  //778.17 is multiplied to convert Btu to lbf.ft
  //12 is multiplied to convert ft to inch
  //=======================================================
  end Ex9_3_c;
end Ex9_3;
